<?php
#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 24.01.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName('Zone Bearbeiten');
requireLogin();
requireRole(['Administrator']);
showSessionAlert();
initializeDatabaseConnection();

$sql = "SELECT * FROM Zones WHERE ZoneID = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$_GET['id']]);

$zoneEntry = $stmt->fetch();

if (!$zoneEntry) {

    header("Location: /administration/zones");
    exit();

}

if (isset($_POST['updateZone'])) {

    if ($_POST['zoneRestricted'] == "Ja") {
        $zoneRestricted = '1';
    } else {
        $zoneRestricted = NULL;
    }

    if ($_POST['zoneAlarmAuthorisation'] == "Ja") {
        $zoneAlarmAuthorisation = '1';
    } else {
        $zoneAlarmAuthorisation = NULL;
    }

    // Daten Updaten
    updateDBEntry('Zones', 'ZoneID', $_GET['id'], 'ZoneName', $_POST['zoneName']);
    updateDBEntry('Zones', 'ZoneID', $_GET['id'], 'ZoneColor', $_POST['zoneColor']);
    updateDBEntry('Zones', 'ZoneID', $_GET['id'], 'ZoneOnExit', $_POST['zoneOnExit']);
    updateDBEntry('Zones', 'ZoneID', $_GET['id'], 'Restricted', $zoneAlarmAuthorisation);
    updateDBEntry('Zones', 'ZoneID', $_GET['id'], 'AlarmAuthorisation', $zoneRestricted);

    // AuditLog: Eintrag erstellen
    addAuditLog($_SESSION['Username'], 'Zonen', 'Zone "' . $zoneEntry['ZoneName'] . '" bearbeitet');

    // Alert: Speichern Erfolgreich
    createSessionAlert("", "Zone <h5 class='pt-2 pb-2'>" . $zoneEntry['ZoneName'] . "</h5> wurde aktualisiert", "success", "false", "2000");

    // Weiterleitung zur Übersicht
    header("Location: /administration/zones");
    exit();

}

if (isset($_POST['deleteZone'])) {

    // AuditLog: Eintrag erstellen
    addAuditLog($_SESSION['Username'], 'Zonen', 'Zone "' . $zoneEntry['ZoneName'] . '" aus dem System entfernt');

    // Alert: Löschen Erfolgreich
    createSessionAlert("", "Zone <h4 class='pt-2 pb-2'>" . $zoneEntry['ZoneName'] . "</h4> wurde erfolgreich gelöscht", "success", "false", "3000");

    // Personen aus der Zone ausbuchen
    updateDBEntry('Identities', 'CurrentZone', $_GET['id'], 'CurrentZone', NULL);

    // Löschen der Daten in der Datenbank
    deleteDBEntry('Zones', 'ZoneID', $_GET['id']);

    // Weiterleitung zur Übersicht
    header("Location: /administration/zones");
    exit();
}

include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<form action="" method="post" id="updateZone" enctype="multipart/form-data">

    <div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
        <div>
            <h4 class="mb-md-0"><?php echo $zoneEntry['ZoneName']; ?></h4>
            <span class="text-secondary">Bearbeiten</span>
        </div>
        <div class="d-flex align-items-center flex-wrap text-nowrap">

            <button class="btn btn-primary btn-icon-text me-2" type="submit" name="updateZone">
                <i class="btn-icon-prepend mdi mdi-check-bold"></i>
                Speichern
            </button>

            <button type="button" class="btn btn-danger btn-icon-text mb-2 mb-md-0 me-2" data-bs-toggle="modal"
                data-bs-target="#modalDeleteZone">
                <i class="btn-icon-prepend mdi mdi-delete"></i>
                Löschen
            </button>

            <a href="/administration/zones" class="btn btn-secondary btn-icon mb-2 mb-md-0">
                <i class="mdi mdi-arrow-left-top"></i>
            </a>

        </div>
    </div>

    <div class="row">

        <div class="col-lg-12 col-xl-4 grid-margin">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    Einstellungen
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="zoneName" class="form-label">Name</label>
                        <input id="zoneName" name="zoneName" class="form-control" type="text"
                            value="<?php echo $zoneEntry['ZoneName']; ?>" autofocus>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Eingeschränkt</label>
                        <select class="js-example-basic-single form-select form-control" name="zoneRestricted"
                            data-width="100%">
                            <option value="Nein">Nein</option>
                            <option value="Ja" <?php if ($zoneEntry['Restricted'] == '1') {
                                echo 'selected';
                            } ?>>Ja
                            </option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Ausgangszone</label>
                        <select class="js-example-basic-single form-select form-control" name="zoneOnExit"
                            data-width="100%">
                            <option value="">Keine Auswahl</option>
                            <?php

                            // Datenbankabfrage
                            $sql = "SELECT * FROM Zones";
                            $stmt = $pdo->query($sql);
                            $Zones = $stmt->fetchAll();

                            if ($Zones) {
                                foreach ($Zones as $Zone) {
                                    echo '<option value="' . $Zone['ZoneID'] . '"';
                                    if ($Zone['ZoneID'] == $zoneEntry['ZoneOnExit']) {
                                        echo ' selected';
                                    }
                                    echo '>' . $Zone['ZoneName'] . '</option>';
                                }
                            }

                            ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="colorCode" class="form-label">Farbe</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="colorCode" name="zoneColor"
                                value="<?php echo $zoneEntry['ZoneColor']; ?>" readonly>
                            <span class="input-group-text bg-transparent">
                                <div id="pickr_addZone"></div>
                            </span>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Alarm-Berechtigung</label>
                        <select class="js-example-basic-single form-select form-control" name="zoneAlarmAuthorisation"
                            data-width="100%">
                            <option value="Nein">Nein</option>
                            <option value="Ja" <?php if ($zoneEntry['AlarmAuthorisation'] == '1') {
                                echo 'selected';
                            } ?>>Ja
                            </option>
                        </select>
                    </div>

                </div>
            </div>
        </div>

    </div>

</form>

<!-- Modal : Zone Löschen -->
<div class="modal fade" id="modalDeleteZone" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form action="" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title">Löschen</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="btn-close"></button>
                </div>
                <div class="modal-body">
                    <p class="fw-bold mb-2">Zone
                        "<?php echo $zoneEntry['ZoneName']; ?>" wirklich
                        löschen?</p>
                    <p class="mb-2">Das Löschen dieser Zone hat folgende Konsequenzen:</p>
                    <p class="mb-2 ms-3"><b>Alle in der Zone eingebuchten Personen</b> werden automatisch ausgebucht und
                        müssen einer neuen Zone zugewiesen werden.</p>
                    <p class="mb-2 ms-3">Diese Personen werden anschließend in der Übersicht mit dem Status <b>„Keine
                            Buchungshistorie“</b> angezeigt.</p>
                    <p>Der Vorgang kann nicht rückgängig gemacht werden.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Abbrechen</button>
                    <button type="submit" class="btn btn-icon-text btn-danger" name="deleteZone">
                        <i class="btn-icon-prepend mdi mdi-delete"></i>
                        Löschen
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>